import java.net.*;
import java.util.*;
import java.io.*;

/**
 *
 * CSTestClient
 * <BR><BR>
 * Klient testowy dla obiektu CommServer.
 *
 * @author  Derek Clayton   derek_clayton@iceinc.com
 * @version 1.0.0
 */

public class CSTestClient {
    private Socket socket;          // gniazdo dla polaczenia
    private String ip;              // numer IP testowanego serwera
    private int port;            // numer portu testowanego serwera

    /**
     * Konstruktor obiektu CSTestClient.  Inicjalizuje wlasciowsci obiektu CSTestClient
     * @param   ip      numer IP testowanego serwera
     * @param   port    numer portu testowanego serwera
    */
    public CSTestClient(String ip, String port) {
        this.ip = ip;
        this.port = (Integer.decode(port)).intValue();

        testServer();
    }

    private void testServer() {
        writeActivity("Attempting to connect to server at " +
        ip + ":" + port);

        // --- proba nawiazania polaczenia z serwerem
        try {
            socket = new Socket(ip, port);
        } catch (UnknownHostException uhe) {
            writeActivity("Unknown Host Exception: " + uhe.getMessage());
        } catch (IOException ioe) {
            writeActivity("IO Exception: " + ioe.getMessage());
        }

        // --- wyswietl informacje o wyniku proby nawiazania polaczenia
        if(socket != null) {
            writeActivity("Connection SUCCESSFUL");
            try {
                socket.close();
            } catch (IOException ioe) {
                writeActivity("IO Exception: " + ioe.getMessage());
            }
        } else {
            writeActivity("Connection FAILED");
        }
    }

       /**
     * Zapisuje wiadomosc w System.out.println w formacie
     * [mm/dd/yy hh:mm:ss] wiadomosc.
     * @param   activity    Wiadomosc.
    */
    public void writeActivity(String activity) {
        // --- odczytaj aktualna date i czas
        Calendar cal = Calendar.getInstance();
        activity = "[" + cal.get(Calendar.MONTH)
                 + "/" + cal.get(Calendar.DAY_OF_MONTH)
                 + "/" + cal.get(Calendar.YEAR)
                 + " "
                 + cal.get(Calendar.HOUR_OF_DAY)
                 + ":" + cal.get(Calendar.MINUTE)
                 + ":" + cal.get(Calendar.SECOND)
                 + "] " + activity + "\n";

        // --- wywiet wartosc activity
        System.out.print(activity);
    }

    public static void main(String args[]) {
        // --- gdy poprawna liczba argumentow
        if(args.length == 2) {
            CSTestClient myCSTC = new CSTestClient(args[0], args[1]);
        } else {
        // w przeciwnym razie wyswietl informacje o skladni
            System.out.println("Skladnia: java CSTestClient [ip] [port]");
        }
    }
}